
function data() {
  function getThemeFromLocalStorage() {
    // if user already changed the theme, use it
    if (window.localStorage.getItem('dark')) {
      return JSON.parse(window.localStorage.getItem('dark'))
    }

    // else return their preferences
    return (
      !!window.matchMedia &&
      window.matchMedia('(prefers-color-scheme: dark)').matches
    )
  }

  function setThemeToLocalStorage(value) {
    window.localStorage.setItem('dark', value)
  }

  return {
    dark: getThemeFromLocalStorage(),
    toggleTheme() {
      this.dark = !this.dark
      setThemeToLocalStorage(this.dark)
    },
    isSideMenuOpen: false,
    toggleSideMenu() {
      this.isSideMenuOpen = !this.isSideMenuOpen
    },
    closeSideMenu() {
      this.isSideMenuOpen = false
    },
    isNotificationsMenuOpen: false,
    toggleNotificationsMenu() {
      this.isNotificationsMenuOpen = !this.isNotificationsMenuOpen
    },
    closeNotificationsMenu() {
      this.isNotificationsMenuOpen = false
    },
    isProfileMenuOpen: false,
    toggleProfileMenu() {
      this.isProfileMenuOpen = !this.isProfileMenuOpen
    },
    closeProfileMenu() {
      this.isProfileMenuOpen = false
    },
    isPagesMenuOpen: false,
    togglePagesMenu() {
      this.isPagesMenuOpen = !this.isPagesMenuOpen
    },
    // Modal
    isModalOpen: false,
    trapCleanup: null,
    openModal(packageData) {
      const package = packageData;
      // Expression: "openModal({"Id":"2","PackageID":"606707","PackageName":"Books","PackageDescriptoin"
      // :"Primary school books","DepartureLocation":"Tabora","Destination":"Moshi","SenderName":"Jane",
      // "SenderContactInfo":"255654893345","ReceiverName":"Michael","ReceiverContactInfo":"765738965",
      // "RecordingAgentID":"1","Status":"Cleared","ShippingFee":"201.55","date":"28\/08\/2023"})"]
      document.getElementById('package-id').textContent = 'ID #' + package["PackageID"];
      document.getElementById('fuggy-package-id').textContent = package["Status"];
      document.getElementById('package-name').textContent = package['PackageName'];
      document.getElementById('package-description').textContent = package["PackageDescriptoin"];
      document.getElementById('package-departure').textContent = package["DepartureLocation"];
      document.getElementById('package-destination').textContent = package["Destination"];
      document.getElementById('package-sender-name').textContent = package["SenderName"];
      document.getElementById('package-sender-contact').textContent = package["SenderContactInfo"];
      document.getElementById('package-receiver-name').textContent = package["ReceiverName"];
      document.getElementById('package-receiver-contact').textContent = package["ReceiverContactInfo"];
      document.getElementById('package-status').textContent = package["Status"];
      document.getElementById('shipping-fee').textContent = package['ShippingFee'];
      // document.getElementById('package-date').textContent = package['date'];
      // console.log(package)

      var paymentStatus = package['PaymentStatus'];
      // alert(paymentStatus);
      if (paymentStatus === 'PAID') {
        document.getElementById('payment-status-info').textContent = package['PaymentStatus'];
      } else {
        document.getElementById('payment-status-info').innerHTML = '<li><a href="record-pay.php?edit='+package["Id"]+'" class="text-red-600 font-semibold cursor-pointer hover:underline">Kamilisha malipo</a></li>';
      }

      const jsonData = JSON.stringify(packageData);
      document.getElementById('jsonData').value = jsonData;
      // document.getElementById('sendButtonReceipt').addEventListener('click', function () {
      //   document.getElementById('dataForm').submit();
      // });

      const jsonData2 = JSON.stringify(packageData);
      document.getElementById('jsonData2').value = jsonData2;
      document.getElementById('sendButtonReceipt').addEventListener('click', function () {
        document.getElementById('dataForm2').submit();
      });

      // passing the data in a hidden input field for form validation
      var packageIdInput = document.getElementById('passed-package-id');
      if (packageIdInput) {
        packageIdInput.value = package["Id"];
    } else {
        console.log("The 'passed-package-id' input element was not found on the page.");
      }
      
      this.isModalOpen = true
      this.trapCleanup = focusTrap(document.querySelector('#modal'))
    },
    closeModal() {
      this.isModalOpen = false
      this.trapCleanup()
    },
    openNormalModel(agentData) {
      const agent = agentData;
      
      // record data fields
      document.getElementById('edit_name').value = agent['agentName'];
      document.getElementById('edit_email').value = agent['agentEmail'];
      document.getElementById('edit_phone').value = agent['agentPhone'];
      document.getElementById('edit_region').value = agent['agentRegion'];

      // passing the data in a hidden input field for form validation
      var selectedAgent = document.getElementById('selected_agent');
      if (selectedAgent) {
        selectedAgent.value = agent['Id'];
      } else {
        console.log("Error: The selected 'agent' does not have an id")
      }

      this.isModalOpen = true
      this.trapCleanup = focusTrap(document.querySelector('#modal'))
    },
    openReceiverMsgModel(receiverData) {
      const receiver = receiverData;

      document.getElementById('receiverName_msg').value = receiver['ReceiverName'];
      document.getElementById('receiverPhone_msg').value = receiver['ReceiverContactInfo'];
      console.log(receiver);

      this.isModalOpen = true
      this.trapCleanup = focusTrap(document.querySelector('#modal'))
    }
  }
}





