<?php
// Sample data array
$items = [
    ["id" => 1, "name" => "Item 1", "description" => "Description for Item 1"],
    ["id" => 2, "name" => "Item 2", "description" => "Description for Item 2"],
    ["id" => 3, "name" => "Item 3", "description" => "Description for Item 3"],
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Popup Example</title>
    <style>
        /* Define CSS styles for the modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }

        .modal-content {
            background-color: white;
            padding: 20px;
            width: 80%;
            max-width: 600px;
            margin: 100px auto;
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
<body>
    <?php foreach ($items as $item): ?>
        <button class="show-modal" data-id="<?= $item['id'] ?>">Show Modal</button>
    <?php endforeach; ?>

    <?php foreach ($items as $item): ?>
        <div class="modal" id="modal-<?= $item['id'] ?>">
            <div class="modal-content">
                <h2><?= $item['name'] ?></h2>
                <p><?= $item['description'] ?></p>
                <button onclick="closeModal('modal-<?= $item['id'] ?>')">Close Modal</button>
            </div>
        </div>
    <?php endforeach; ?>

    <script>
        // Function to open the modal
        function openModal(modalId) {
            var modal = document.getElementById(modalId);
            modal.style.display = "block";
        }

        // Function to close the modal
        function closeModal(modalId) {
            var modal = document.getElementById(modalId);
            modal.style.display = "none";
        }

        // Add click event listeners to show the modal
        var buttons = document.querySelectorAll('.show-modal');
        buttons.forEach(function(button) {
            button.addEventListener('click', function() {
                var itemId = button.getAttribute('data-id');
                openModal('modal-' + itemId);
            });
        });
    </script>
</body>
</html>
