<?php include("framework/init.php"); ?>

<body>
   <div class="flex h-screen bg-gray-50 dark:bg-gray-900" :class="{ 'overflow-hidden': isSideMenuOpen }">
      <?php include("framework/nav.php"); ?>

      <div class="flex flex-col flex-1 w-full">
         <?php include("framework/header.php"); ?>

         <!-- Main body -->
         <main class="h-full overflow-y-auto">
            <div class="container px-6 mx-auto grid"><br>
               <h4 class="mb-4 text-lg font-semibold text-gray-600 dark:text-gray-300">
                  Search Results
               </h4>
               <?php
               if (isset($_GET['results'])) {
                  $searchResults = unserialize(base64_decode($_GET['results']));

                  if (empty($searchResults)) {
                     echo '<h4 class="mb-4 text-lg font-semibold text-red-600 dark:text-red-400">No matching packages found.</h4>';
                  } else { ?>
                     <!-- New Table -->
                     <div class="w-full overflow-hidden rounded-lg shadow-xs">
                        <div class="w-full overflow-x-auto">
                           <table class="w-full whitespace-no-wrap">
                              <thead>
                                 <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                                    <th class="px-4 py-3">Package Info</th>
                                    <th class="px-4 py-3">Payment</th>
                                    <th class="px-4 py-3">Location</th>
                                    <th class="px-4 py-3">Destination</th>
                                    <th class="px-4 py-3">Sender</th>
                                    <th class="px-4 py-3">Reciever</th>
                                    <th class="px-4 py-3">Date</th>
                                    <th class="px-4 py-3">Status</th>
                                    <th class="px-4 py-3">Action</th>
                                 </tr>
                              </thead>
                              <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                                 <?php
                                 foreach ($searchResults as $package) { ?>
                                    <tr class="text-gray-700 dark:text-gray-400">
                                       <td class="px-4 py-3">
                                          <div class="flex items-center text-sm">
                                             <!-- Avatar with inset shadow -->
                                             <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                                                <img class="object-cover w-full h-full rounded-full" src="<?= resolvePath('assets/img/package.jpg') ?>" alt="" loading="lazy" />
                                                <div class="absolute inset-0 rounded-full shadow-inner" aria-hidden="true"></div>
                                             </div>
                                             <div>
                                                <p class="font-semibold"><?= truncateString($package["PackageName"]) ?></p>
                                                <p class="text-xs text-gray-600 dark:text-gray-400">
                                                   ID #<?= $package["PackageID"] ?>
                                                </p>
                                             </div>
                                          </div>
                                       </td>
                                       <td class="px-4 py-3 text-xs">
                                          <!-- <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
                                             Paid
                                          </span> -->
                                          <?php
                                          if ($package["PaymentStatus"] == "PAID") {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-green-500 bg-green-100 rounded-full dark:text-green-100 dark:bg-green-500">
                                                PAID
                                          </span>';
                                          } else {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-full dark:text-red-100 dark:bg-red-700">
                                             UNPAID
                                          </span>';
                                          }
                                          ?>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <?= $package["DepartureLocation"] ?>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <?= $package["Destination"] ?>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <div class="flex items-center text-sm">
                                             <div>
                                                <p class="font-semibold"><?= $package["SenderName"] ?></p>
                                                <p class="text-xs text-gray-600 dark:text-gray-400">
                                                   <?= $package["SenderContactInfo"] ?>
                                                </p>
                                             </div>
                                          </div>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <div class="flex items-center text-sm">
                                             <div>
                                                <p class="font-semibold"><?= $package["ReceiverName"] ?></p>
                                                <p class="text-xs text-gray-600 dark:text-gray-400">
                                                   <?= $package["ReceiverContactInfo"] ?>
                                                </p>
                                             </div>
                                          </div>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <?= $package['date'] ?>
                                       </td>
                                       <td class="px-4 py-3 text-xs">
                                          <?php
                                          if ($package['Status'] == 'Delivered') {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
                                             ' . $package["Status"] . '
                                          </span>';
                                          } elseif ($package['Status'] == 'Received') {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-full dark:text-red-100 dark:bg-red-700">
                                              ' . $package["Status"] . '
                                          </span>';
                                          } elseif ($package['Status'] == 'In Transit') {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-orange-700 bg-orange-100 rounded-full dark:text-orange-500 dark:bg-orange-400">
                                              ' . $package["Status"] . '
                                          </span>';
                                          } elseif ($package['Status'] == 'Cleared') {
                                             echo '<span class="px-2 py-1 font-semibold leading-tight text-gray-700 bg-gray-100 rounded-full dark:text-gray-100 dark:bg-gray-700">
                                              ' . $package["Status"] . '
                                          </span>';
                                          }
                                          ?>
                                       </td>
                                       <td class="px-4 py-3 text-sm">
                                          <div class="flex items-center space-x-4 text-sm">
                                             <button type="button" @click="openModal(<?php echo htmlspecialchars(json_encode($package), ENT_QUOTES, 'UTF-8'); ?>)" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Edit">
                                                <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                                   <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                                                </svg>
                                             </button>
                                          </div>
                                       </td>
                                       </td>
                                    </tr>
                           <?php }
                              }
                           } else {
                              echo '<h4 class="mb-4 text-lg font-semibold text-gray-600 dark:text-gray-300">No search results found.</h4>';
                           }
                           ?>
                           <!-- Pop up card -->
                           <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 z-30 flex items-end bg-black bg-opacity-50 sm:items-center sm:justify-center">
                              <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 transform translate-y-1/2" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0  transform translate-y-1/2" @click.away="closeModal" @keydown.escape="closeModal" class="w-full px-6 py-4 overflow-hidden bg-white rounded-t-lg dark:bg-gray-800 sm:rounded-lg sm:m-4 sm:max-w-xl" role="dialog" id="modal">
                                 <!-- Remove header if you don't want a close icon. Use modal body to place modal tile. -->
                                 <header class="flex justify-end">
                                    <button class="inline-flex items-center justify-center w-6 h-6 text-gray-400 transition-colors duration-150 rounded dark:hover:text-gray-200 hover: hover:text-gray-700" aria-label="close" @click="closeModal">
                                       <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20" role="img" aria-hidden="true">
                                          <path d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" fill-rule="evenodd"></path>
                                       </svg>
                                    </button>
                                 </header>
                                 <!-- Modal body -->
                                 <div class="mt-4 mb-6">
                                    <!-- Modal title -->
                                    <p class="mb-2 text-lg font-semibold text-gray-700 dark:text-gray-300">
                                       <span id="package-id"></span>
                                    </p>
                                    <div class="dividder text-gray-700 dark:text-gray-400" style="display: grid; grid-template-columns:auto auto; justify-content:space-between">
                                       <h3><b>Package Name: </b><span id="package-name"></span></h3>
                                       <h3><b>Status: </b><span id="package-status"></span></h3>
                                    </div>

                                    <label class="block mt-4 text-sm">
                                       <span class="text-gray-700 dark:text-gray-400">Description</span>
                                       <div id="package-description" class="block w-full mt-1 text-sm dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 form-textarea focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" rows="3"></div>
                                    </label>
                                    <div class="text-sm  package-actors text-gray-700 dark:text-gray-400" style="display: grid; grid-template-columns:auto auto; margin:2% auto;">
                                       <div class="package-actors-sende">
                                          <h3 style="font-weight: 550;">Sender</h3>
                                          <li><b style="font-weight: 500;">Name: </b><span id="package-sender-name"></span></li>
                                          <li><b style="font-weight: 500;">Phone: </b><span id="package-sender-contact"></span></li>
                                       </div>
                                       <div class="package-actors-reciever">
                                          <h3 style="font-weight: 550;">Reciever</h3>
                                          <li><b style="font-weight: 500;">Name: </b><span id="package-receiver-name"></span></li>
                                          <li><b style="font-weight: 500;">Phone: </b><span id="package-receiver-contact"></span></li>
                                       </div>
                                    </div>
                                    <div style="display: grid; grid-template-columns:auto auto; margin:2% auto;">
                                       <div class="package-actors-location text-gray-700 dark:text-gray-400">
                                          <h3>Shipping Info</h3>
                                          <div class="text-sm">
                                             <li><b style="font-weight: 500;">Departure Point: </b><span id="package-departure"></span></li>
                                             <li><b style="font-weight: 500">Destination Point: </b><span id="package-destination"></span></li>
                                             <li><b style="font-weight: 500">Shipping Fee: </b>Tsh <span id="shipping-fee"></span></li>
                                          </div>
                                       </div>
                                       <div class="text-gray-700 dark:text-gray-400">
                                          <h2 class="font-semibold">Payment Status</h2>
                                          <span id="payment-status-info">
                                             <a href="#" class="text-red-600 font-semibold cursor-pointer hover:underline">Kamilisha malipo</a>
                                          </span>
                                       </div>
                                    </div>
                                 </div>
                                 <div>
                                    <span class="flex justify-between">
                                       <form id="dataForm" method="POST" action="<?= resolvePath('app/Controller/Receipt.php') ?>" target="_blank">
                                          <input type="hidden" id="jsonData" name="jsonData" value="">
                                          <button name="sendButtonReceipt" id="sendButtonReceipt" class="flex items-center justify-between px-4 py-2 text-sm font-medium leading-5 transition-colors duration-150 text-green-500 bg-green-100 border border-transparent rounded-lg active:bg-green-500 hover:bg-green-600 dark:text-green-100 dark:bg-green-500 focus:outline-none focus:shadow-outline-purple">
                                             <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-4 h-4 mr-2 -ml-1 bi bi-receipt" viewBox="0 0 16 16">
                                                <path d="M1.92.506a.5.5 0 0 1 .434.14L3 1.293l.646-.647a.5.5 0 0 1 .708 0L5 1.293l.646-.647a.5.5 0 0 1 .708 0L7 1.293l.646-.647a.5.5 0 0 1 .708 0L9 1.293l.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .801.13l.5 1A.5.5 0 0 1 15 2v12a.5.5 0 0 1-.053.224l-.5 1a.5.5 0 0 1-.8.13L13 14.707l-.646.647a.5.5 0 0 1-.708 0L11 14.707l-.646.647a.5.5 0 0 1-.708 0L9 14.707l-.646.647a.5.5 0 0 1-.708 0L7 14.707l-.646.647a.5.5 0 0 1-.708 0L5 14.707l-.646.647a.5.5 0 0 1-.708 0L3 14.707l-.646.647a.5.5 0 0 1-.801-.13l-.5-1A.5.5 0 0 1 1 14V2a.5.5 0 0 1 .053-.224l.5-1a.5.5 0 0 1 .367-.27zm.217 1.338L2 2.118v11.764l.137.274.51-.51a.5.5 0 0 1 .707 0l.646.647.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.509.509.137-.274V2.118l-.137-.274-.51.51a.5.5 0 0 1-.707 0L12 1.707l-.646.647a.5.5 0 0 1-.708 0L10 1.707l-.646.647a.5.5 0 0 1-.708 0L8 1.707l-.646.647a.5.5 0 0 1-.708 0L6 1.707l-.646.647a.5.5 0 0 1-.708 0L4 1.707l-.646.647a.5.5 0 0 1-.708 0l-.509-.51z" />
                                                <path d="M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm8-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5z" />
                                             </svg>
                                             <span>Get Reciept</span>
                                          </button>
                                       </form>
                                       <form id="dataForm2" method="POST" action="<?= resolvePath('app/Controller/Shipmark.php') ?>" target="_blank">
                                          <input type="hidden" id="jsonData2" name="jsonData2" value="">
                                          <button name="sendButtonReceipt" id="sendButtonReceipt" class="flex items-center justify-between px-4 py-2 text-sm font-medium leading-5 transition-colors duration-150 text-green-500 bg-green-100 border border-transparent rounded-lg active:bg-green-500 hover:bg-green-600 dark:text-green-100 dark:bg-green-500 focus:outline-none focus:shadow-outline-purple">
                                             <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-4 h-4 mr-2 -ml-1 bi bi-receipt" viewBox="0 0 16 16">
                                                <path d="M1.92.506a.5.5 0 0 1 .434.14L3 1.293l.646-.647a.5.5 0 0 1 .708 0L5 1.293l.646-.647a.5.5 0 0 1 .708 0L7 1.293l.646-.647a.5.5 0 0 1 .708 0L9 1.293l.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .801.13l.5 1A.5.5 0 0 1 15 2v12a.5.5 0 0 1-.053.224l-.5 1a.5.5 0 0 1-.8.13L13 14.707l-.646.647a.5.5 0 0 1-.708 0L11 14.707l-.646.647a.5.5 0 0 1-.708 0L9 14.707l-.646.647a.5.5 0 0 1-.708 0L7 14.707l-.646.647a.5.5 0 0 1-.708 0L5 14.707l-.646.647a.5.5 0 0 1-.708 0L3 14.707l-.646.647a.5.5 0 0 1-.801-.13l-.5-1A.5.5 0 0 1 1 14V2a.5.5 0 0 1 .053-.224l.5-1a.5.5 0 0 1 .367-.27zm.217 1.338L2 2.118v11.764l.137.274.51-.51a.5.5 0 0 1 .707 0l.646.647.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.509.509.137-.274V2.118l-.137-.274-.51.51a.5.5 0 0 1-.707 0L12 1.707l-.646.647a.5.5 0 0 1-.708 0L10 1.707l-.646.647a.5.5 0 0 1-.708 0L8 1.707l-.646.647a.5.5 0 0 1-.708 0L6 1.707l-.646.647a.5.5 0 0 1-.708 0L4 1.707l-.646.647a.5.5 0 0 1-.708 0l-.509-.51z" />
                                                <path d="M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm8-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5z" />
                                             </svg>
                                             <span>Get Shipmark</span>
                                          </button>
                                       </form>
                                    </span>
                                 </div>
                                 <form action="" method="POST">
                                    <input type="hidden" id="passed-package-id" name="Passed-Package-Id">
                                    <div class="text-gray-700 dark:text-gray-400">
                                       <h3>Update Status</h3>
                                       <select name="status" class="block w-full mt-1 text-sm dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 form-select focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray">
                                          <option id="fuggy-package-id"></option>
                                          <option value="Received">Received</option>
                                          <option value="In Transit">In Transit</option>
                                          <option value="Delivered">Delivered</option>
                                          <option value="Cleared">Cleared</option>
                                       </select>
                                    </div>
                                    <div>
                                    </div>
                                    <footer class="flex flex-col items-center justify-end px-6 py-3 -mx-6 -mb-4 space-y-4 sm:space-y-0 sm:space-x-6 sm:flex-row bg-gray-50 dark:bg-gray-800">
                                       <button type="button" @click="closeModal" class="w-full px-5 py-3 text-sm font-medium leading-5 dark:text-cool-gray-50text-white text-gray-700 transition-colors duration-150 border border-gray-300 rounded-lg dark:text-gray-400 sm:px-4 sm:py-2 sm:w-auto active:bg-transparent hover:border-gray-500 focus:border-gray-500 active:text-gray-500 focus:outline-none focus:shadow-outline-gray">
                                          Cancel
                                       </button>
                                       <button type="submit" name="updatePackage" class="w-full px-5 py-3 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                                          Update
                                       </button>
                                    </footer>
                                 </form>
                              </div>
                           </div>
                              </tbody>
                           </table>
                           <!-- End of Main body -->
                        </div>
                     </div>
                     <br>
            </div>
         </main>
      </div>
</body>