<?php
$encodedJson = urldecode($_SERVER['QUERY_STRING']);

if (isset($_GET['print'])) {
  $urlEncodedData = $_GET['print'];
  $base64Data = urldecode($urlEncodedData);
  $jsonData = base64_decode($base64Data);
  $receivedData = json_decode($jsonData, true);

  $packageName = $receivedData["packageName"];
  $departure = $receivedData["departure"];
  $destination = $receivedData["destination"];
  $amount = number_format($receivedData["amount"], 2, '.', ',');
  $sender = $receivedData["sender"];
  $senderTel = $receivedData["senderTel"];
  $receiver = $receivedData["receiver"];
  $receiverTel = $receivedData["receiverTel"];
  $packageValue = number_format($receivedData["packageValue"], 2, '.', ',');
  $agentName = $receivedData["agentName"];
  $date = $receivedData["date"];
} else {
  echo "Error: No Data Received";
}
?>
<!DOCTYPE html>
<!--
Copyright 2015 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
<html>

<head>
  <title>Bluetooth Printer</title>
  <meta name="description" content="Print text and images to a Bluetooth Printer with a Web Bluetooth app." />

  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <meta name="viewport" content="width=device-width, minimum-scale=1.0, initial-scale=1, user-scalable=yes" />
  <meta name="mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-capable" content="yes" />

  <script src="bower_components/webcomponentsjs/webcomponents-lite.min.js"></script>

  <!-- Polymer components -->
  <link rel="import" href="bower_components/paper-progress/paper-progress.html" />
  <link rel="import" href="bower_components/paper-slider/paper-slider.html" />
  <link rel="import" href="bower_components/paper-button/paper-button.html" />
  <link rel="import" href="bower_components/paper-card/paper-card.html" />
  <link rel="import" href="bower_components/paper-dialog/paper-dialog.html" />
  <link rel="import" href="bower_components/paper-input/paper-input.html" />
  <link rel="import" href="bower_components/paper-input/paper-input-container.html" />
  <link rel="import" href="bower_components/paper-input/paper-input-error.html" />
  <link rel="import" href="bower_components/paper-input/paper-input-char-counter.html" />
  <link rel="import" href="bower_components/paper-input/paper-textarea.html" />

  <link rel="import" href="bower_components/paper-styles/color.html" />
  <link rel="stylesheet" href="bower_components/paper-styles/demo.css" />

  <style is="custom-style">
    paper-progress {
      width: 100%;
    }

    paper-progress.blue {
      paper-progress-active-color: var(--paper-light-blue-500);
      paper-progress-secondary-color: var(--paper-light-blue-100);
    }

    paper-slider {
      width: 100%;
    }

    paper-slider.blue {
      paper-slider-active-color: var(--paper-light-blue-500);
      paper-slider-knob-color: var(--paper-light-blue-500);
    }

    paper-button {
      display: block;
      margin-bottom: 2px;
    }

    paper-button.colorful {
      color: #4285f4;
    }

    paper-button[raised].colorful {
      background: #4285f4;
      color: #fff;
    }

    paper-button.blue {
      color: var(--paper-light-blue-500);
      paper-button-flat-focus-color: var(--paper-light-blue-50);
    }

    body {
      background-color: var(--paper-grey-50);
    }

    #cards {
      margin-left: auto;
      margin-right: auto;
      max-width: 400px;
    }

    paper-card {
      margin-bottom: 5px;
      margin-top: 5px;
      width: 100%;
    }

    paper-card#logo {
      @apply (--layout-vertical);
      @apply (--layout-center);
    }
  </style>
</head>

<body unresolved>
  <a href="">Back to Home Page </a>
  <div id="cards">
    <paper-card heading="Bluetooth Printer">
      <span>

      </span>
      <div class="card-content">
        <paper-progress id="progress" indeterminate></paper-progress>
      </div>
    </paper-card>

    <!-- <paper-card id="logo">
        <div class="card-content">
          <image id="image" src="logo-black.png" width="200px"></image>
        </div>
      </paper-card> -->

    <paper-card>
      <div class="card-content">
        <paper-textarea id="packageName" label="Package Name" value="<?= $packageName ?>"></paper-textarea>
        <paper-textarea id="departure" label="From" value="<?= $departure ?>"></paper-textarea>
        <paper-textarea id="destination" label="Destination" value="<?= $destination ?>"></paper-textarea>
        <paper-textarea id="packageValue" label="Package Value" value="<?= $packageValue ?>"></paper-textarea>
        <paper-textarea id="sender" label="Sender Name" value="<?= $sender ?>"></paper-textarea>
        <paper-textarea id="senderTel" label="Phone No" value="<?= $senderTel ?>"></paper-textarea>
        <paper-textarea id="receiver" label="Receiver Name" value="<?= $receiver ?>"></paper-textarea>
        <paper-textarea id="receiverTel" label="Phone No" value="<?= $receiverTel ?>"></paper-textarea>
        <paper-textarea id="amount" label="Shipping Cost" value="<?= $amount ?>"></paper-textarea>
        <paper-textarea id="agentName" label="Agent Name" value="<?= $agentName ?>"></paper-textarea>
        <paper-textarea id="date" label="Date" value="<?= $date ?>"></paper-textarea>

        <!-- Add more inputs as needed -->
      </div>
    </paper-card>

    <paper-card>
      <div class="card-content">
        <paper-button id="print" raised class="colorful">Print</paper-button>
      </div>
    </paper-card>

    <paper-dialog id="dialog">
      <h2>Error</h2>
      <p>Could not connect to bluetooth device!</p>
    </paper-dialog>
  </div>

  <script>
    "use strict";
    document.addEventListener("WebComponentsReady", function() {
      let progress = document.querySelector("#progress");
      let dialog = document.querySelector("#dialog");
      let message = document.querySelector("#message");
      let printButton = document.querySelector("#print");
      let printCharacteristic;
      let index = 0;
      let data;
      progress.hidden = true;

      let image = document.querySelector("#image");
      // Use the canvas to get image data
      let canvas = document.createElement("canvas");
      // Canvas dimensions need to be a multiple of 40 for this printer
      canvas.width = 120;
      canvas.height = 120;
      let context = canvas.getContext("2d");
      // context.drawImage(image, 0, 0, canvas.width, canvas.height);
      // let imageData = context.getImageData(0, 0, canvas.width, canvas.height).data;

      function getDarkPixel(x, y) {
        // Return the pixels that will be printed black
        let red = imageData[(canvas.width * y + x) * 4];
        let green = imageData[(canvas.width * y + x) * 4 + 1];
        let blue = imageData[(canvas.width * y + x) * 4 + 2];
        return red + green + blue > 0 ? 1 : 0;
      }

      function getImagePrintData() {
        if (imageData == null) {
          console.log("No image to print!");
          return new Uint8Array([]);
        }
        // Each 8 pixels in a row is represented by a byte
        let printData = new Uint8Array(
          (canvas.width / 8) * canvas.height + 8
        );
        let offset = 0;
        // Set the header bytes for printing the image
        printData[0] = 29; // Print raster bitmap
        printData[1] = 118; // Print raster bitmap
        printData[2] = 48; // Print raster bitmap
        printData[3] = 0; // Normal 203.2 DPI
        printData[4] = canvas.width / 8; // Number of horizontal data bits (LSB)
        printData[5] = 0; // Number of horizontal data bits (MSB)
        printData[6] = canvas.height % 256; // Number of vertical data bits (LSB)
        printData[7] = canvas.height / 256; // Number of vertical data bits (MSB)
        offset = 7;
        // Loop through image rows in bytes
        for (let i = 0; i < canvas.height; ++i) {
          for (let k = 0; k < canvas.width / 8; ++k) {
            let k8 = k * 8;
            //  Pixel to bit position mapping
            printData[++offset] =
              getDarkPixel(k8 + 0, i) * 128 +
              getDarkPixel(k8 + 1, i) * 64 +
              getDarkPixel(k8 + 2, i) * 32 +
              getDarkPixel(k8 + 3, i) * 16 +
              getDarkPixel(k8 + 4, i) * 8 +
              getDarkPixel(k8 + 5, i) * 4 +
              getDarkPixel(k8 + 6, i) * 2 +
              getDarkPixel(k8 + 7, i);
          }
        }
        return printData;
      }

      function handleError(error) {
        console.log(error);
        progress.hidden = true;
        printCharacteristic = null;
        dialog.open();
      }

      function sendNextImageDataBatch(resolve, reject) {
        // Can only write 256 bytes at a time to the characteristic
        // Need to send the image data in 256 byte batches
        if (index + 256 < data.length) {
          printCharacteristic
            .writeValue(data.slice(index, index + 256))
            .then(() => {
              index += 256;
              sendNextImageDataBatch(resolve, reject);
            })
            .catch((error) => reject(error));
        } else {
          // Send the last bytes
          if (index < data.length) {
            printCharacteristic
              .writeValue(data.slice(index, data.length))
              .then(() => {
                resolve();
              })
              .catch((error) => reject(error));
          } else {
            resolve();
          }
        }
      }

      function sendImageData() {
        // index = 0;
        // data = getImagePrintData();
        // return new Promise(function(resolve, reject) {
        //   sendNextImageDataBatch(resolve, reject);
        // });
        return 0;
      }

      function getTextData() {
        let packageName = document.querySelector("#packageName").value;
        let departure = document.querySelector("#departure").value;
        let destination = document.querySelector("#destination").value;
        let amount = document.querySelector("#amount").value;
        let sender = document.querySelector("#sender").value;
        let senderTel = document.querySelector("#senderTel").value;
        let receiver = document.querySelector("#receiver").value;
        let receiverTel = document.querySelector("#receiverTel").value;
        let packageValue = document.querySelector("#packageValue").value;
        let agentName = document.querySelector("#agentName").value;
        let date = document.querySelector("#date").value;
        // Add more variables for other inputs as needed

        // Combine the input values into a single string

        //Receipt format
        let textData = `\n\n         ELLYMO INVESTMENT\n_ _ _ _ _ _ _ _ _ _ _ _ _ _ _\n\n          CARGO RECEIPT\n_ _ _ _ _ _ _ _ _ _ _ _ _ _ _\n        TRACKING NO #993435\n______________________________\nPackage:   ${packageName}\nPackage Value: ${packageValue}\nFrom:   ${departure}\nDestination:   ${destination}\Shipping Cost:   ${amount}\n______________________________\nSender:   ${sender}\nPhone No:   ${senderTel}\nReceiver:   ${receiver}\nPhone No:   ${receiverTel}\n______________________________\n\nAgent:   ${agentName}\nDate:   ${date}\n\nThanks for choosing Ellymc Transport  \nContact 0742 114 498\n\n\n\n\n`;
        // Add more lines for other inputs as needed

        return textData;
      }

      // function sendTextData(textData) {
      //   // Get the bytes for the text
      //   let encoder = new TextEncoder("utf-8");
      //   // Add line feed + carriage return chars to text
      //   let text = encoder.encode(textData + "\u000A\u000D");
      //   return printCharacteristic.writeValue(text).then(() => {
      //     console.log("Write done.");
      //   });
      // }

      function sendTextData(textData) {
        // Get the bytes for the text
        let encoder = new TextEncoder("utf-8");
        // Add line feed + carriage return chars to text
        let formattedTextData = encoder.encode(textData + "\u000A\u000D");

        // Can only write 512 bytes at a time to the characteristic
        // Need to send the text data in 256-byte batches
        let index = 0;

        function sendNextTextDataBatch(resolve, reject) {
          if (index + 256 < formattedTextData.length) {
            printCharacteristic
              .writeValue(formattedTextData.slice(index, index + 256))
              .then(() => {
                index += 256;
                sendNextTextDataBatch(resolve, reject);
              })
              .catch((error) => reject(error));
          } else {
            if (index < formattedTextData.length) {
              printCharacteristic
                .writeValue(
                  formattedTextData.slice(index, formattedTextData.length)
                )
                .then(() => {
                  setTimeout(() => {
                    console.log("Write done."); // Log after each batch is written
                    resolve();
                  }, 2000);
                })
                .catch((error) => reject(error));
            } else {
              console.log("All batches written."); // Log after all batches are written
              resolve();
            }
          }
        }

        return new Promise((resolve, reject) => {
          sendNextTextDataBatch(resolve, reject);
        });
      }

      function sendPrinterData() {

        // Get formatted text data from inputs
        let textData = getTextData();

        // Print text data
        sendTextData(getTextData())
          .then(() => {
            progress.hidden = true;
          })
          .catch(handleError);
      }

      printButton.addEventListener("click", function() {
        progress.hidden = false;
        if (printCharacteristic == null) {
          navigator.bluetooth
            .requestDevice({
              filters: [{
                services: ["000018f0-0000-1000-8000-00805f9b34fb"],
              }, ],
            })
            .then((device) => {
              console.log("> Found " + device.name);
              console.log("Connecting to GATT Server...");
              return device.gatt.connect();
            })
            .then((server) =>
              server.getPrimaryService("000018f0-0000-1000-8000-00805f9b34fb")
            )
            .then((service) =>
              service.getCharacteristic(
                "00002af1-0000-1000-8000-00805f9b34fb"
              )
            )
            .then((characteristic) => {
              // Cache the characteristic
              printCharacteristic = characteristic;
              sendPrinterData();
            })
            .catch(handleError);
        } else {
          sendPrinterData();
        }
      });
    });
  </script>
</body>

</html>