<?php
// require_once '../../../config/routes.php';
$receivedJSON = $_POST['jsonData2'];

// Check if data was received
if ($receivedJSON !== null) {
    $postData = json_decode($receivedJSON, true);

    if ($postData !== null) {
        // Data successfully decoded
        $Id = $postData["Id"];
        $PackageID = $postData["PackageID"];
        $PackageName = $postData["PackageName"];
        $PackageDescription = $postData["PackageDescriptoin"]; // Note the typo in your original data
        $DepartureLocation = $postData["DepartureLocation"];
        $Destination = $postData["Destination"];
        $SenderName = $postData["SenderName"];
        $SenderContactInfo = $postData["SenderContactInfo"];
        $ReceiverName = $postData["ReceiverName"];
        $ReceiverContactInfo = $postData["ReceiverContactInfo"];
        $RecordingAgentID = $postData["RecordingAgentID"];
        $Status = $postData["Status"];
        $Paymentstatus = $postData["PaymentStatus"];
        $ShippingFee = $postData["ShippingFee"];
        $ShippingFee = number_format($ShippingFee, 2, '.', ',');
        $date = $postData["date"];
        $today = date('jS M Y', strtotime('today'));
        $date= date('d/m/Y', strtotime($date));
    } else {
        echo "Error decoding JSON data.";
    }
} else {
    echo "No data received.";
}

ob_end_clean();
require('fpdf/fpdf.php');

// Instantiate and use the FPDF class
$pdf = new FPDF('P', 'mm', 'A4');

$pdf->AddPage();
/*output the result*/

/*set font to arial, bold, 14pt*/
$pdf->SetFont('Arial', 'B', 20);

/*Cell(width , height , text , border , end line , [align] )*/

// Add an image to the left side of the header
$pdf->Image('https://express.smai.co.tz/assets/img/smaireal.jpg', 10, 10, 30);

$pdf->Cell(50, 10, '', 0, 0);
$pdf->Cell(59, 5, 'SMAI EXPRESS RECEIPT #'.$PackageID, 0, 0);
$pdf->Cell(59, 10, '', 0, 1);

$pdf->Ln(15); // Add a 1 cm (10 mm) vertical space

$pdf->Cell(50, 10, '', 0, 0);
$pdf->Cell(59, 5, '', 0, 0);
$pdf->Cell(59, 10, '', 0, 1);

$pdf->SetFont('', '',);
$pdf->Cell(71, 5, 'TRACKING NO #'.$PackageID, 0, 0);
$pdf->Cell(59, 5, '', 0, 2);
$pdf->Cell(59, 5, '', 0, 1);

$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(71, 5, 'MTUMAJI', 0, 0);
$pdf->Cell(59, 5, '', 0, 0);
$pdf->Cell(59, 5, 'Status:'.$Status, 0, 1);

$pdf->SetFont('Arial', '', 10);

$pdf->Cell(130, 5, 'Name: '.$SenderName, 0, 0);
$pdf->Cell(25, 5, '', 0, 0);
$pdf->Cell(34, 5, '', 0, 1);

$pdf->Cell(130, 5, 'Location: '.$DepartureLocation, 0, 0);
$pdf->Cell(25, 5, 'Date Issued:', 0, 0);
$pdf->Cell(34, 5, $today, 0, 1);
$pdf->Cell(130, 5, 'Phone No: '.$SenderContactInfo, 0, 1);

$pdf->Cell(130, 5, '', 0, 0);
$pdf->Cell(25, 5, 'Receipt No:', 0, 0);
$pdf->Cell(34, 5, 'ORD001', 0, 1);

$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(130, 5, 'MPOKEAJI', 0, 0);
$pdf->Cell(59, 5, '', 0, 0);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(189, 10, '', 0, 1);
$pdf->Cell(130, 5, 'Name: '.$ReceiverName, 0, 0);
$pdf->Cell(25, 5, '', 0, 0);
$pdf->Cell(34, 5, '', 0, 1);
$pdf->Cell(130, 5, 'Location: '.$DepartureLocation, 0, 0);
$pdf->Cell(25, 5, '', 0, 0);
$pdf->Cell(34, 5, '', 0, 1);
$pdf->Cell(130, 5, 'Phone No: '.$ReceiverContactInfo, 0, 0);
$pdf->Cell(59, 5, 'Payment Status:'.$Paymentstatus, 0, 1);


$pdf->Cell(50, 10, '', 0, 1);

$pdf->SetFont('Arial', 'B', 10);
/*Heading Of the table*/
$pdf->Cell(10, 6, 'Sl', 1, 0, 'C');
$pdf->Cell(80, 6, 'Description', 1, 0, 'C');
$pdf->Cell(23, 6, 'Qty', 1, 0, 'C');
$pdf->Cell(30, 6, 'Unit Price', 1, 0, 'C');
$pdf->Cell(20, 6, 'Extra', 1, 0, 'C');
$pdf->Cell(25, 6, 'Total', 1, 1, 'C');/*end of line*/

/*Heading Of the table end*/
$pdf->SetFont('Arial', '', 10);

for ($i = 0; $i <= 0; $i++) {
    $pdf->Cell(10, 6, $i + 1, 1, 0);
    $pdf->Cell(80, 6, $PackageName, 1, 0);
    $pdf->Cell(23, 6, '1', 1, 0, 'R');
    $pdf->Cell(30, 6, $ShippingFee, 1, 0, 'R');
    $pdf->Cell(20, 6, '0.00', 1, 0, 'R');
    $pdf->Cell(25, 6, $ShippingFee, 1, 1, 'R');
}

$pdf->Cell(118, 6, '', 0, 0);
$pdf->Cell(25, 6, 'Subtotal', 0, 0);
$pdf->Cell(45, 6, $ShippingFee, 1, 1, 'R');

// Add a title for the declaration
$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(189, 10, 'Declaration', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(189, 10, 'The above-mentioned cargo has been received by SMAI EXPRESS in good condition unless
otherwise stated. ...', 0, 1, 'L');
$pdf->Cell(189, 10, 'The cargo is accepted subject to the terms and conditions of the carriage agreement between the sender and SMAI EXPRESS', 0, 1, 'L');
$pdf->Output();
