<?php
require '../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

include("../Models/Packages.php");
// the /vendor/autoload is for excel
// this file contains the logic of the app and some functions, other functions can be found in /config/functions.php
if (isset($_POST['AddPackage'])) {

   // dd($_POST);
   // header("Location:" . resolvePath('app/Controller/bluetooth-printer/'));
   // die;
   $PackageID = generateOrderID();
   $PackageName = $_POST["PackageName"];
   $PackageDescriptoin =  $_POST["PackageDescriptoin"]; // ignore typeError 👀 
   $DepartureLocation = $_SESSION['loggedInAgent']['Region'];
   $Destination = $_POST["Destination"];
   $SenderName = $_POST["SenderName"];
   $accountType = $_POST["accountType"];
   $VendorName = $_POST["VendorName"];
   $Shipway = $_POST["Shipway"];
   $PackageValue = $_POST["PackageValue"];
   $PaymentStatus = $_POST["PaymentStatus"];
   $PaymentChannel = $_POST["PaymentChannel"];
   $TransactionID = $_POST["TransactionID"];
   $SenderContactInfo = $_POST["SenderContactInfo"];
   $ReceiverName = $_POST["ReceiverName"];
   $ReceiverContactInfo = $_POST["ReceiverContactInfo"];
   $RecordingAgentID = $_SESSION['loggedInAgent']['AgentID'];
   $Status = "Received";
   $ShippingFee = $_POST["ShippingFee"];

   $Insert = "INSERT INTO `Package`(`PackageID`, `PackageName`, `PackageDescriptoin`, `DepartureLocation`, `Destination`, `SenderName`, `SenderContactInfo`, `ReceiverName`, `ReceiverContactInfo`, `RecordingAgentID`, `Status`, `PaymentStatus`, `PaymentChannel`, `ShippingFee`, `TransactionID`, `Shipway`, `PackageValue`, `VendorName`) 
               VALUES ('$PackageID','$PackageName','$PackageDescriptoin','$DepartureLocation','$Destination','$SenderName','$SenderContactInfo','$ReceiverName','$ReceiverContactInfo','$RecordingAgentID','$Status', '$PaymentStatus','$PaymentChannel', '$ShippingFee','$TransactionID','$Shipway','$PackageValue', '$VendorName')";

   $InsertConfirm = mysqli_query($conn, $Insert) or die(mysqli_error($conn));

   if ($PaymentChannel === "CASH") {
      $checkAgentQuery = "SELECT * FROM `Payments` WHERE `Agent_Id` = '$RecordingAgentID'";
      $checkAgentResult = mysqli_query($conn, $checkAgentQuery) or die(mysqli_error($conn));

      if (mysqli_num_rows($checkAgentResult) > 0) {
         // Agent exists, update the existing record
         $existingRecord = mysqli_fetch_assoc($checkAgentResult);
         // Calculate new total amount
         $newTotalAmount = $existingRecord['Total_amount'] + $ShippingFee;

         // Update the record
         $updateQuery = "UPDATE `Payments` SET `Total_amount` = '$newTotalAmount' WHERE `Agent_Id` = '$RecordingAgentID'";
         $updateResult = mysqli_query($conn, $updateQuery) or die(mysqli_error($conn));
      } else {
         $nothingYet = 0;
         $NextInsert = "INSERT INTO `Payments`(`Agent_Id`, `Total_amount`, `Payed`) VALUES ('$RecordingAgentID','$ShippingFee','$nothingYet')";
         $EnterRecord = mysqli_query($conn, $NextInsert) or die(mysqli_error($conn));
      }
   }

   if ($InsertConfirm) {
      echo "Record entered successfully";
      // call the function to send sms to the actors
      recieverSMS($ReceiverName, $PackageID, $DepartureLocation, $ReceiverContactInfo);

      // Add a delay of, for example, 5 seconds
      // sleep(15);  // You can adjust the delay time as needed

      senderSMS($SenderName, $PackageID, $Destination, $SenderContactInfo);
      $receiptArr = [
         "packageName" => $PackageName,
         "departure" => $DepartureLocation,
         "destination" => $Destination,
         "amount" => $ShippingFee,
         "sender" => $SenderName,
         "senderTel" => $SenderContactInfo,
         "receiver" => $ReceiverName,
         "receiverTel" => $ReceiverContactInfo,
         "packageValue" => $PackageValue,
         "agentName" => $_SESSION['loggedInAgent']['AgentIName'],
         "date" => date("d-m-Y")
      ];
      $receiptArrJson = json_encode($receiptArr);
      $base64Data = base64_encode($receiptArrJson);
      $urlEncodedData = urlencode($base64Data);
      header("Location:" . resolvePathBeta("app/Controller/bluetooth-printer/index.php?print=$urlEncodedData"));
   } else {
      echo "Failed to set record. Contact Admin for support";
   }
}

function GetPackage($packages)
{
   // $selectedPackage = null;
   foreach ($packages as $package) : ?>

      <tr class="text-gray-700 dark:text-gray-400">
         <td class="px-4 py-3">
            <div class="flex items-center text-sm">
               <!-- Avatar with inset shadow -->
               <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                  <input id="default-checkbox" type="checkbox" name="items[]" value="<?= $package["Id"] ?>" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
               </div>
               <div>
                  <p class="font-semibold"><?= truncateString($package["PackageName"]) ?></p>
                  <p class="text-xs text-gray-600 dark:text-gray-400">
                     ID #<?= $package["PackageID"] ?>
                  </p>
               </div>
            </div>
         </td>
         <td class="px-4 py-3 text-xs">
            <!-- <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
            Paid
         </span> -->
            <?php
            if ($package["PaymentStatus"] == "PAID") {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-green-500 bg-green-100 rounded-full dark:text-green-100 dark:bg-green-500">
                  PAID
            </span>';
            } else {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-full dark:text-red-100 dark:bg-red-700">
               UNPAID
            </span>';
            }
            ?>
         </td>
         <td class="px-4 py-3 text-sm">
            <?= $package["DepartureLocation"] ?>
         </td>
         <td class="px-4 py-3 text-sm">
            <?= $package["Destination"] ?>
         </td>
         <td class="px-4 py-3 text-sm">
            <div class="flex items-center text-sm">
               <div>
                  <p class="font-semibold"><?= $package["SenderName"] ?></p>
                  <p class="text-xs text-gray-600 dark:text-gray-400">
                     <?= $package["SenderContactInfo"] ?>
                  </p>
               </div>
            </div>
         </td>
         <td class="px-4 py-3 text-sm">
            <div class="flex items-center text-sm">
               <div>
                  <p class="font-semibold"><?= $package["ReceiverName"] ?></p>
                  <p class="text-xs text-gray-600 dark:text-gray-400">
                     <?= $package["ReceiverContactInfo"] ?>
                  </p>
               </div>
            </div>
         </td>
         <td class="px-4 py-3 text-sm">
            <?= $package['date'] ?>
         </td>
         <td class="px-4 py-3 text-xs">
            <?php
            if ($package['Status'] == 'Delivered') {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
            ' . $package["Status"] . '
         </span>';
            } elseif ($package['Status'] == 'Received') {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-full dark:text-red-100 dark:bg-red-700">
            ' . $package["Status"] . '
        </span>';
            } elseif ($package['Status'] == 'In Transit') {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-orange-700 bg-orange-100 rounded-full dark:text-orange-500 dark:bg-orange-400">
            ' . $package["Status"] . '
        </span>';
            } elseif ($package['Status'] == 'Cleared') {
               echo '<span class="px-2 py-1 font-semibold leading-tight text-gray-700 bg-gray-100 rounded-full dark:text-gray-100 dark:bg-gray-700">
            ' . $package["Status"] . '
        </span>';
            }
            ?>
         </td>
         <td class="px-4 py-3 text-sm">
            <div class="flex items-center space-x-4 text-sm">
               <button type="button" @click="openModal(<?php echo htmlspecialchars(json_encode($package), ENT_QUOTES, 'UTF-8'); ?>)" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Edit">
                  <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                     <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                  </svg>
               </button>
            </div>
         </td>
         </td>
      </tr>
   <?php endforeach; ?>

   <!-- Pop up card -->
   <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 z-30 flex items-end bg-black bg-opacity-50 sm:items-center sm:justify-center">
      <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 transform translate-y-1/2" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0  transform translate-y-1/2" @click.away="closeModal" @keydown.escape="closeModal" class="w-full px-6 py-4 overflow-hidden bg-white rounded-t-lg dark:bg-gray-800 sm:rounded-lg sm:m-4 sm:max-w-xl" role="dialog" id="modal">
         <!-- Remove header if you don't want a close icon. Use modal body to place modal tile. -->
         <header class="flex justify-end">
            <button class="inline-flex items-center justify-center w-6 h-6 text-gray-400 transition-colors duration-150 rounded dark:hover:text-gray-200 hover: hover:text-gray-700" aria-label="close" @click="closeModal">
               <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20" role="img" aria-hidden="true">
                  <path d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" fill-rule="evenodd"></path>
               </svg>
            </button>
         </header>
         <!-- Modal body -->
         <div class="mt-4 mb-6">
            <!-- Modal title -->
            <p class="mb-2 text-lg font-semibold text-gray-700 dark:text-gray-300">
               <span id="package-id"></span>
            </p>
            <div class="dividder text-gray-700 dark:text-gray-400" style="display: grid; grid-template-columns:auto auto; justify-content:space-between">
               <h3><b>Package Name: </b><span id="package-name"></span></h3>
               <h3><b>Status: </b><span id="package-status"></span></h3>
            </div>

            <label class="block mt-4 text-sm">
               <span class="text-gray-700 dark:text-gray-400">Description</span>
               <div id="package-description" class="block w-full mt-1 text-sm dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 form-textarea focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" rows="3"></div>
            </label>
            <div class="text-sm  package-actors text-gray-700 dark:text-gray-400" style="display: grid; grid-template-columns:auto auto; margin:2% auto;">
               <div class="package-actors-sende">
                  <h3 style="font-weight: 550;">Sender</h3>
                  <li><b style="font-weight: 500;">Name: </b><span id="package-sender-name"></span></li>
                  <li><b style="font-weight: 500;">Phone: </b><span id="package-sender-contact"></span></li>
               </div>
               <div class="package-actors-reciever">
                  <h3 style="font-weight: 550;">Reciever</h3>
                  <li><b style="font-weight: 500;">Name: </b><span id="package-receiver-name"></span></li>
                  <li><b style="font-weight: 500;">Phone: </b><span id="package-receiver-contact"></span></li>
               </div>
            </div>
            <div style="display: grid; grid-template-columns:auto auto; margin:2% auto;">
               <div class="package-actors-location text-gray-700 dark:text-gray-400">
                  <h3>Shipping Info</h3>
                  <div class="text-sm">
                     <li><b style="font-weight: 500;">Departure Point: </b><span id="package-departure"></span></li>
                     <li><b style="font-weight: 500">Destination Point: </b><span id="package-destination"></span></li>
                     <li><b style="font-weight: 500">Shipping Fee: </b>Tsh <span id="shipping-fee"></span></li>
                  </div>
               </div>
               <div class="text-gray-700 dark:text-gray-400">
                  <h2 class="font-semibold">Payment Status</h2>
                  <span id="payment-status-info">
                     <a href="#" class="text-red-600 font-semibold cursor-pointer hover:underline">Kamilisha malipo</a>
                  </span>
               </div>
            </div>
         </div>
         <div>
            <span class="flex justify-between">
               <form id="dataForm" method="POST" action="<?= resolvePath('admin/app/Controller/bluetooth-printer/index.php') ?>">
                  <input type="hidden" id="jsonData" name="jsonData" value="">
                  <button type="submit" name="printButton" id="printButton" class="flex items-center justify-between px-4 py-2 text-sm font-medium leading-5 transition-colors duration-150 text-green-500 bg-green-100 border border-transparent rounded-lg active:bg-green-500 hover:bg-green-600 dark:text-green-100 dark:bg-green-500 focus:outline-none focus:shadow-outline-purple">
                     <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-4 h-4 mr-2 -ml-1 bi bi-receipt" viewBox="0 0 16 16">
                        <path d="M1.92.506a.5.5 0 0 1 .434.14L3 1.293l.646-.647a.5.5 0 0 1 .708 0L5 1.293l.646-.647a.5.5 0 0 1 .708 0L7 1.293l.646-.647a.5.5 0 0 1 .708 0L9 1.293l.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .801.13l.5 1A.5.5 0 0 1 15 2v12a.5.5 0 0 1-.053.224l-.5 1a.5.5 0 0 1-.8.13L13 14.707l-.646.647a.5.5 0 0 1-.708 0L11 14.707l-.646.647a.5.5 0 0 1-.708 0L9 14.707l-.646.647a.5.5 0 0 1-.708 0L7 14.707l-.646.647a.5.5 0 0 1-.708 0L5 14.707l-.646.647a.5.5 0 0 1-.708 0L3 14.707l-.646.647a.5.5 0 0 1-.801-.13l-.5-1A.5.5 0 0 1 1 14V2a.5.5 0 0 1 .053-.224l.5-1a.5.5 0 0 1 .367-.27zm.217 1.338L2 2.118v11.764l.137.274.51-.51a.5.5 0 0 1 .707 0l.646.647.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.509.509.137-.274V2.118l-.137-.274-.51.51a.5.5 0 0 1-.707 0L12 1.707l-.646.647a.5.5 0 0 1-.708 0L10 1.707l-.646.647a.5.5 0 0 1-.708 0L8 1.707l-.646.647a.5.5 0 0 1-.708 0L6 1.707l-.646.647a.5.5 0 0 1-.708 0L4 1.707l-.646.647a.5.5 0 0 1-.708 0l-.509-.51z" />
                        <path d="M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm8-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5z" />
                     </svg>
                     <span>Get Reciept</span>
                  </button>
               </form>
               <form id="dataForm2" method="POST" action="<?= resolvePath('app/Controller/Shipmark.php') ?>" target="_blank">
                  <input type="hidden" id="jsonData2" name="jsonData2" value="">
                  <button name="sendButtonReceipt" id="sendButtonReceipt" class="flex items-center justify-between px-4 py-2 text-sm font-medium leading-5 transition-colors duration-150 text-green-500 bg-green-100 border border-transparent rounded-lg active:bg-green-500 hover:bg-green-600 dark:text-green-100 dark:bg-green-500 focus:outline-none focus:shadow-outline-purple">
                     <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-4 h-4 mr-2 -ml-1 bi bi-receipt" viewBox="0 0 16 16">
                        <path d="M1.92.506a.5.5 0 0 1 .434.14L3 1.293l.646-.647a.5.5 0 0 1 .708 0L5 1.293l.646-.647a.5.5 0 0 1 .708 0L7 1.293l.646-.647a.5.5 0 0 1 .708 0L9 1.293l.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .801.13l.5 1A.5.5 0 0 1 15 2v12a.5.5 0 0 1-.053.224l-.5 1a.5.5 0 0 1-.8.13L13 14.707l-.646.647a.5.5 0 0 1-.708 0L11 14.707l-.646.647a.5.5 0 0 1-.708 0L9 14.707l-.646.647a.5.5 0 0 1-.708 0L7 14.707l-.646.647a.5.5 0 0 1-.708 0L5 14.707l-.646.647a.5.5 0 0 1-.708 0L3 14.707l-.646.647a.5.5 0 0 1-.801-.13l-.5-1A.5.5 0 0 1 1 14V2a.5.5 0 0 1 .053-.224l.5-1a.5.5 0 0 1 .367-.27zm.217 1.338L2 2.118v11.764l.137.274.51-.51a.5.5 0 0 1 .707 0l.646.647.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.509.509.137-.274V2.118l-.137-.274-.51.51a.5.5 0 0 1-.707 0L12 1.707l-.646.647a.5.5 0 0 1-.708 0L10 1.707l-.646.647a.5.5 0 0 1-.708 0L8 1.707l-.646.647a.5.5 0 0 1-.708 0L6 1.707l-.646.647a.5.5 0 0 1-.708 0L4 1.707l-.646.647a.5.5 0 0 1-.708 0l-.509-.51z" />
                        <path d="M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm8-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5z" />
                     </svg>
                     <span>Get Shipmark</span>
                  </button>
               </form>
            </span>
         </div>
         <form action="" method="POST">
            <input type="hidden" id="passed-package-id" name="Passed-Package-Id">
            <div class="text-gray-700 dark:text-gray-400">
               <h3>Update Status</h3>
               <select name="status" class="block w-full mt-1 text-sm dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 form-select focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray">
                  <option id="fuggy-package-id"></option>
                  <option value="Received">Received</option>
                  <option value="In Transit">In Transit</option>
                  <option value="Delivered">Delivered</option>
                  <option value="Cleared">Cleared</option>
               </select>
            </div>
            <div>
            </div>
            <footer class="flex flex-col items-center justify-end px-6 py-3 -mx-6 -mb-4 space-y-4 sm:space-y-0 sm:space-x-6 sm:flex-row bg-gray-50 dark:bg-gray-800">
               <button type="button" @click="closeModal" class="w-full px-5 py-3 text-sm font-medium leading-5 dark:text-cool-gray-50text-white text-gray-700 transition-colors duration-150 border border-gray-300 rounded-lg dark:text-gray-400 sm:px-4 sm:py-2 sm:w-auto active:bg-transparent hover:border-gray-500 focus:border-gray-500 active:text-gray-500 focus:outline-none focus:shadow-outline-gray">
                  Cancel
               </button>
               <button type="submit" name="updatePackage" class="w-full px-5 py-3 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                  Update
               </button>
            </footer>
         </form>
      </div>
   </div>
<?php
}

// filter packages
function filterAndProcessPackages($packages, $statusToRemove)
{
   // Filter out packages with the specified status
   $filteredPackages = array_filter($packages, function ($package) use ($statusToRemove) {
      return $package['Status'] !== $statusToRemove;
   });

   // Call the original function with the filtered packages
   GetPackage($filteredPackages);
}
//Beta version of returning skeleton filtered array
function filterPackagesBeta($packages, $statusToRemove)
{
   $filteredPackages = array_filter($packages, function ($package) use ($statusToRemove) {
      return $package['Status'] !== $statusToRemove;
   });
   return $filteredPackages;
}
// archieved packages
function renderArchievedPackages($packages, $statusToRemove)
{
   // Filter out packages with the specified status
   $filteredPackages = array_filter($packages, function ($package) use ($statusToRemove) {
      return $package['Status'] === $statusToRemove;
   });

   // Call the original function with the filtered packages
   GetPackage($filteredPackages);
}

// return packages from the last 7 days
function getDataFromPastSevenDays($packages)
{
   $result = array();

   $sevenDaysAgo = date("d/m/Y", strtotime("-7 days"));
   foreach ($packages as $item) {
      $date = date("d/m/Y", strtotime($item["date"]));

      if (strtotime($date) >= strtotime($sevenDaysAgo)) {
         $result[] = $item;
      }
   }

   return $result;
}

function calculate($packages, $operation)
{
   $filteredPackagesVer = filterPackagesBeta($packages, "Cleared");
   $total = 0;

   foreach ($filteredPackagesVer as $package) {
      switch ($operation) {
         case "Total":
            $total++;
            break;
         case "money":
            $total += $package["ShippingFee"];
            break;
         case "In Transit":
         case "Delivered":
            // Add more cases for different statuses if needed
            if ($package["Status"] === $operation) {
               $total++;
            }
            break;
            // Add more cases for other operations if needed
         default:
            // Handle invalid operation
            return "Invalid operation";
      }
   }

   return $total;
}
// start search functinality
function searchPackage($packages, $searchTerm)
{
   $searchResults = array();

   foreach ($packages as $package) {
      // Check if the PackageID or any phone number contains the search term
      /**
       * UPADATE: Removed the phone number option
       */
      if (
         strpos($package["PackageID"], $searchTerm) !== false
         // || strpos($package["SenderContactInfo"], $searchTerm) !== false ||
         // strpos($package["ReceiverContactInfo"], $searchTerm) !== false
      ) {
         $searchResults[] = $package;
      }
   }

   return $searchResults;
}

if (isset($_GET['find']) && !empty($_GET['find'])) {
   $searchTerm = strtolower($_GET['find']);
   $searchResults = searchPackage($packages, $searchTerm);

   // Encode and serialize the search results to be passed in the URL
   $encodedResults = base64_encode(serialize($searchResults));

   $searchResults = unserialize(base64_decode($_GET['results']));
   // dd($searchResults);
   // Redirect to the search results page with the results as a parameter
   header("Location: " . resolvePathBeta("app/views/search-results.php?results=$encodedResults"));
   exit();
}
// end search functionality

// update functionality
if (isset($_POST['updatePackage'])) {
   // dd($_POST);
   $package_id = $_POST["Passed-Package-Id"];
   $package_status = $_POST["status"];

   // Find the package with the matching Id in the array
   $matching_packages = array_filter($packages, function ($package) use ($package_id) {
      return $package['Id'] == $package_id;
   });

   if (!empty($matching_packages)) {
      // Extract the required data from the first (and only) matching package
      $matching_package = reset($matching_packages);
      $cargoID = $matching_package['PackageID'];
      $trackPrimaryKey = $matching_package['Id'];
      $paymentStatus = $matching_package['PaymentStatus'];
      $receiver = $matching_package['ReceiverName'];
      $recieverNo = $matching_package['ReceiverContactInfo'];

      if (($paymentStatus === 'UNPAID' || !$paymentStatus) && $package_status === 'Cleared') {
         header("Location:" . resolvePathBeta('app/views/record-pay.php?edit=' . $trackPrimaryKey . ''));
         die();
      }
      $newQuery = "UPDATE `Package` SET `Status` = ? WHERE `Id` = ?";
      $stmt = $conn->prepare($newQuery);

      if ($stmt) {
         // Bind parameters and execute the statement
         $stmt->bind_param("si", $package_status, $package_id);
         if ($stmt->execute()) {
            echo "Updated successfully";
            if ($package_status == 'Delivered') {
               // call delivered funciton
               deliveredSMS($receiver, $cargoID, $recieverNo);
            }
            header("Location: ./");
         } else {
            echo "Update failed: " . $stmt->error;
         }
         $stmt->close();
      } else {
         echo "Statement preparation failed: " . $conn->error;
      }
   } else {
      echo "Package with ID $package_id not found in the array.";
   }
}

// Custom sms
if (isset($_POST['sendCustomSMS'])) {
   $name = $_POST["recipientName"];
   $tel = $_POST["SenderContactInfo"];
   $msg = $_POST["message12"];

   sendSMSAPI($tel, $msg);
}

// Upload excel file not --ignored
if (isset($_POST['uploadExcelFile'])) {
   /**
    * STEP 1: Upload the file to local storage
    */
   $target_dir = 'uploads/';
   $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
   $uploadOk = 1;
   $callDB = 0;
   $docFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

   try {
      // Check if the target directory exists
      if (!file_exists($target_dir)) {
         throw new Exception("Target directory does not exist.");
      }

      // Check if the file was received
      if (!isset($_FILES["fileToUpload"]) || $_FILES["fileToUpload"]["error"] !== UPLOAD_ERR_OK) {
         throw new Exception("Error in receiving the file.");
      }

      // Check if file already exists
      if (file_exists($target_file)) {
         throw new Exception("Sorry, file already exists.");
      }

      // Check if the uploaded file is empty
      if ($_FILES["fileToUpload"]["size"] == 0) {
         throw new Exception("Sorry, your file is empty.");
      }

      // Check file size
      if ($_FILES["fileToUpload"]["size"] > 2000000) {
         throw new Exception("Sorry, your file is too large.");
      }

      // Check if $uploadOk is set to 0 by an error
      if ($uploadOk == 0) {
         throw new Exception("Your file was not uploaded.");
      }

      if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
         echo "<script> alert('The file " . htmlspecialchars(basename($_FILES["fileToUpload"]["name"])) . " has been uploaded.')</script>";
         $callDB = 1;
      } else {
         $absolutePath = realpath($target_file);
         throw new Exception("Error in moving the uploaded file to: $absolutePath");
      }
   } catch (Exception $e) {
      echo "<script> alert('Error: " . $e->getMessage() . "')</script>";
   }

   /**
    * STEP 2: Retrieve the data from the excel file then store it in an array
    */
   if ($callDB == 1) {
      require '../../vendor/autoload.php';
      // Create a new PhpSpreadsheet object
      $excelFilePath = realpath($target_file);
      $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($excelFilePath);
      $sheet = $spreadsheet->getActiveSheet();
      $excelData = array();

      // Check if the worksheet exists
      if ($sheet) {
         // Iterate through rows and columns to extract cell data
         foreach ($sheet->getRowIterator() as $row) {
            $rowData = array(); // Initialize an array for each row of data
            $hasNonEmptyCell = false; // Flag to track if row has at least one non-empty cell

            foreach ($row->getCellIterator() as $cell) {
               $cellValue = $cell->getValue();
               $rowData[] = $cellValue;

               // Check if the cell has a non-empty value
               if (!empty($cellValue)) {
                  $hasNonEmptyCell = true;
               }
            }

            // If at least one cell in the row has a non-empty value, add it to the data array
            if ($hasNonEmptyCell) {
               $excelData[] = $rowData;
            }
         }
         // echo "Data extracted sucecssfully <br>";
         /**
          * Explaination: Exclude the first row (header) from the data
          * array_shift($excelData);
          * NOTE: Some files may contain empty cells that go horizontally 
          * run dd($$excelData) to see the results stored in the array
          */
      } else {
         echo "No active sheet found in the spreadsheet. <br>";
      }
   }


   /**
    * STEP 3: Work with the data and store it in the Database
    */

   /*  remove the first element (containing headers) */
   $temp = $excelData;
   $headers = array_shift($temp);
   $dbArray = $temp;

   if ($dbArray) {
      // dd($dbArray);
      // echo "Step 1: Prepare database array <br>";
      $successfulInsertions = 0;

      // Insertion template  👀 
      $sql = "INSERT INTO `Package`(`PackageID`, `PackageName`, `PackageDescriptoin`, `DepartureLocation`, `Destination`, `SenderName`, `SenderContactInfo`, `ReceiverName`, `ReceiverContactInfo`, `RecordingAgentID`, `Status`, `PaymentStatus`, `PaymentChannel`, `ShippingFee`, `TransactionID`, `Shipway`, `VendorName`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      // echo "Step 2: Built Table template <br>";

      // Get info for sending messeges
      $smsData = array();

      foreach ($dbArray as $row) {
         $PackageID = generateOrderID();
         $PackageName = !empty($row[14]) ? $row[14] : "null";
         $PackageDescriptoin = !empty($row[15]) ? $row[15] : "null"; // ignore typeError 👀
         $DepartureLocation = !empty($row[5]) ? $row[5] : "null";
         $Destination = !empty($row[6]) ? $row[6] : "null";
         $SenderName = !empty($row[1]) ? $row[1] : "null";
         $SenderContactInfo = !empty($row[2]) ? $row[2] : "null";
         $ReceiverName = !empty($row[3]) ? $row[3] : "null";
         $ReceiverContactInfo = !empty($row[4]) ? $row[4] : "null";
         $RecordingAgentID = $_SESSION['loggedInAgent']['AgentID'];
         $Status = "Received";
         $PaymentStatus = !empty($row[7]) ? strtoupper($row[7]) : "UNPAID";
         $PaymentChannel = !empty($row[8]) ? $row[8] : "null";
         $ShippingFee = !empty($row[10]) ? $row[10] : "null";
         $TransactionID = !empty($row[9]) ? $row[9] : "null";
         $Shipway = !empty($row[11]) ? $row[11] : "null";
         $VendorName = !empty($row[12]) ? $row[12] : "null";

         /**
          * Catch some data that will be used for messages and store in smsData Array
          */
         if (!empty($PackageID) && !empty($SenderName) && !empty($SenderContactInfo) && !empty($ReceiverName) && !empty($ReceiverContactInfo) && !empty($DepartureLocation) && !empty($Destination)) {
            $smsRowData = [
               'PackageID' => $PackageID,
               'SenderName' => $SenderName,
               'SenderContactInfo' => $SenderContactInfo,
               'ReceiverName' => $ReceiverName,
               'ReceiverContactInfo' => $ReceiverContactInfo,
               'DepartureLocation' => $DepartureLocation,
               'Destination' => $Destination,
            ];

            $smsData[] = $smsRowData;
         }

         $stmt = $conn->prepare($sql);
         // echo "Step 3: Executed prepare statement <br>";
         $stmt->bind_param("sssssssssisssdsss", $PackageID, $PackageName, $PackageDescriptoin, $DepartureLocation, $Destination, $SenderName, $SenderContactInfo, $ReceiverName, $ReceiverContactInfo, $RecordingAgentID, $Status, $PaymentStatus, $PaymentChannel, $ShippingFee, $TransactionID, $Shipway, $VendorName);

         // echo "Step 4: Successful bind Param <br>";

         if ($stmt->execute() === false) {
            echo "Error: " . $stmt->error;
            echo "Failed to insert items";
         } else {
            $successfulInsertions++;
            // echo "Step 5: Inserted item in row($successfulInsertions) <br>";
         }

         $stmt->close();
      }
      // echo "Successful insertions: " . $successfulInsertions . "<br>";
   }

   /**
    * STEP 4: Send SMS to the sender and receiver on confirm package is recorded
    */

   if ($smsData) {
      foreach ($smsData as $row) {

         $PackageID = $row['PackageID'];
         $SenderName = $row['SenderName'];
         $SenderContactInfo = $row['SenderContactInfo'];
         $ReceiverName = $row['ReceiverName'];
         $ReceiverContactInfo = $row['ReceiverContactInfo'];
         $DepartureLocation = $row['DepartureLocation'];
         $Destination = $row['Destination'];

         recieverSMS($ReceiverName, $PackageID, $DepartureLocation, $ReceiverContactInfo);
         senderSMS($SenderName, $PackageID, $Destination, $SenderContactInfo);
      }
      echo "<script> alert('Message sent to receipients') </script>";
   }
   // die(0);
}

// Multiple checkout select form
if (isset($_POST['submit_action'])) {
   $submitAction = $_POST["submit_action"];
   $status = $_POST["status"];
   $data = $_POST["items"];
   $count = 0;

   if (!$data) {
      header("Location: ../views/packages.php");
      echo '<script> alert("Select item first") </script>';
   }


   if ($submitAction === "Edit") {
      $sql = "UPDATE `Package` SET `Status`='$status' WHERE `Package`.`Id` = ?";
      foreach ($data as $row) {
         $stmt = $conn->prepare($sql);
         $stmt->bind_param("i", $row);

         if ($stmt->execute() === false) {
            echo "Error: " . $stmt->error;
            echo "Failed to insert items";
         } else {
            $count++;
         }

         $stmt->close();
      }
      header("Location: ../views/packages.php");
   } elseif ($submitAction === "Export") {
      $excel_data = array();

      $temp = $packages;
      foreach ($temp as $item) {
         if (in_array($item['Id'], $data)) {
            $excel_data[] = $item;
         }
      }
      $filename = "smai_data_export_" . date('Ymd') . ".xls";
      header("Content-Type: application/vnd.ms-excel");
      header("Content-Disposition: attachment; filename=\"$filename\"");
      $show_coloumn = false;
      if (!empty($excel_data)) {
         foreach ($excel_data as $record) {
            if (!$show_coloumn) {
               // display field/column names in first row
               echo implode("\t", array_keys($record)) . "\n";
               $show_coloumn = true;
            }
            echo implode("\t", array_values($record)) . "\n";
         }
      }
      exit;
   } elseif ($submitAction === "Delete") {
      $sql = "DELETE FROM `Package` WHERE `Package`.`Id` = ?";
      foreach ($data as $row) {
         $stmt = $conn->prepare($sql);
         $stmt->bind_param("i", $row);

         if ($stmt->execute() === false) {
            echo "Error: " . $stmt->error;
            echo "Failed to insert items";
         } else {
            $count++;
         }

         $stmt->close();
      }
      header("Location: ../views/packages.php");
   } else {
      echo "Warning: Invalid form submition";
   }

   die(0);
}
