<?php
include("../Models/Agents.php");

function returnAgents($agents) //working here
{
    foreach ($agents as $agent) : ?>
        <tr class="text-gray-700 dark:text-gray-400">
            <td class="px-4 py-3">
                <div class="flex items-center text-sm">
                    <!-- Avatar with inset shadow -->
                    <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                        <img class="object-cover w-full h-full rounded-full" src="<?= resolvePath('assets/img/user.png') ?>" alt="" loading="lazy" />
                        <div class="absolute inset-0 rounded-full shadow-inner" aria-hidden="true"></div>
                    </div>
                    <div>
                        <p class="font-semibold"><?= $agent["agentName"] ?></p>
                        <p class="text-xs text-gray-600 dark:text-gray-400">
                            <?= $agent["agentEmail"] ?>
                        </p>
                    </div>
                </div>
            </td>
            <td class="px-4 py-3 text-sm">
                <?= $agent["agentPhone"] ?>
            </td>
            <td class="px-4 py-3 text-xs">
                <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
                    <?= $agent["agentEmail"] ?>
                </span>
            </td>
            <td class="px-4 py-3 text-sm">
                <?= $agent["agentRegion"] ?>
            </td>
            <td>
                <button type="button" title="view" @click="openNormalModel(<?php echo htmlspecialchars(json_encode($agent), ENT_QUOTES, 'UTF-8'); ?>)" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray">
                    <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                    </svg>
                </button>
            </td>
        </tr>
    <?php endforeach; ?>
    <!-- Main modal -->
    <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 z-30 flex items-end bg-black bg-opacity-50 sm:items-center sm:justify-center">
        <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 transform translate-y-1/2" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0  transform translate-y-1/2" @click.away="closeModal" @keydown.escape="closeModal" class="border border-gray-600 rounded-md dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800 sm:rounded-lg sm:m-4 sm:max-w-xl" role="dialog" id="modal">
            <div class="w-auto bg-white dark:bg-gray-800 rounded-md p-3">
                <h2 class="font-semibold text-lg mb-4">Edit Agent Section</h2>
                <form method="POST">
                    <input type="hidden" name="selected_agent" id="selected_agent" value="">
                    <label class="text-base font-semiblold block py-2" for="edit_name">Agent Name: <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="edit_name" id="edit_name" value=""></label>
                    <label class="text-base font-semiblold block py-2" for="edit_email">Agent Email: <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="edit_email" id="edit_email" value=""></label>
                    <label class="text-base font-semiblold block py-2" for="edit_phone">Agent Phone: <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="edit_phone" id="edit_phone" value=""></label>
                    <label class="text-base font-semiblold block py-2" for="edit_region">Agent Region: <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="edit_region" id="edit_region" value=""></label>
                    <span class="text-red-600 hover:underline cursor-pointer" onclick="document.getElementById('confirm-delete').classList.remove('hidden')">Delete Agent?</span>
                    <div class="hidden border border-gray-400 p-2" id="confirm-delete">
                        <span class="text-orange-500 block">Warning: This action cannot be undone</span>
                        <button title="Cancel" type="button" class="dark:bg-gray-800 bg-gray-50 text-gray-800 dark:text-gray-200 hover:underline cursor-pointer" onclick="document.getElementById('confirm-delete').classList.add('hidden')">
                            Cancel
                        </button>
                        <input title="Proceed to delete agent" type="submit" name="edit_agent_form" id="deleteForm" class="text-red-600 hover:underline border-none dark:bg-gray-800 bg-gray-50 mx-2" value="Delete">
                    </div>
                    <div class="flex flex-col items-center justify-end px-6 py-3 -mx-6 -mb-4 space-y-4 sm:space-y-0 sm:space-x-6 sm:flex-row">
                        <button type="button" @click="closeModal" class="px-5 py-3 text-sm font-medium leading-5 dark:text-cool-gray-50text-white text-gray-700 transition-colors duration-150 border border-gray-300 rounded-lg dark:text-gray-400 sm:px-4 sm:py-2 sm:w-auto active:bg-transparent hover:border-gray-500 focus:border-gray-500 active:text-gray-500 focus:outline-none focus:shadow-outline-gray">
                            Cancel
                        </button>
                        <input class="px-5 py-3 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" type="submit" value="Update" name="edit_agent_form" id="submitForm">
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php
}

function trackCashPay($trackPay)
{
    foreach ($trackPay as $see) {
        $rem = $see["Total_amount"] - $see["Payed"];
    ?>
        <tr class="text-gray-700 dark:text-gray-400">
            <td class="px-4 py-3">
                <div class="flex items-center text-sm">
                    <!-- Avatar with inset shadow -->
                    <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                        <img class="object-cover w-full h-full rounded-full" src="<?= resolvePath('assets/img/user.png') ?>" alt="" loading="lazy" />
                        <div class="absolute inset-0 rounded-full shadow-inner" aria-hidden="true"></div>
                    </div>
                    <div>
                        <p class="font-semibold"><?= $see["agentName"] ?></p>
                        <p class="text-xs text-gray-600 dark:text-gray-400">
                            <?= $see["agentPhone"] ?>
                        </p>
                    </div>
                </div>
            </td>
            <td class="px-4 py-3 text-sm text-blue-500  dark:bg-gray-800">
                Tsh <?= formatPrice($see["Total_amount"]) ?> /=
            </td>
            <td class="px-4 py-3 text-sm text-green-600  dark:bg-gray-800">
                Tsh <?= formatPrice($see["Payed"]) ?>/=
            </td>
            <td class="px-4 py-3 text-sm text-orange-500  dark:bg-gray-800">
                Tsh <?= formatPrice($rem) ?>/=
            </td>

            <!-- record new payment form -->
            <form action="" method="POST">
                <td class="px-4 py-3">
                    <input type="hidden" name="record_id" value="<?= $see["Id"] ?>">
                    <input type="hidden" name="Total_amount" value="<?= $see["Total_amount"] ?>">
                    <input type="hidden" name="current_amount_payed" value="<?= $see["Payed"] ?>">
                    <?php
                    if ($rem <= 0) {
                        echo '<input class="py-1 w-full dark:bg-gray-800 bg-gray-50 text-gray-700  dark:placeholder-gray-600 text-sm dark:text-gray-200 focus:outline-none form-input cursor-not-allowed" type="number" max="' . $rem . '" min="0" name="update_payed_amount" placeholder="Enter Amount" disabled>';
                    } else {
                        echo '<input class="py-1 w-full dark:bg-gray-800 bg-gray-50 text-gray-700 placeholder-gray-600 text-sm dark:text-gray-200 focus:outline-none form-input" type="number" max="' . $rem . '" min="0" name="update_payed_amount" placeholder="Enter Amount">';
                    }
                    ?>
                </td>
                <td>
                    <?php
                    if ($rem <= 0) {
                        echo '<button type="button" title="Fully paid" class=" w-full flex items-center justify-between px-5 py3 text-sm font-medium leading-5 text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100 transition-colors duration-150  border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-green-100 hover:bg-green-100 focus:outline-none">
                        Paid
                    </button>';
                    } else {
                        echo '<button type="submit" title="update payment" name="update_payment" class=" w-full flex items-center justify-between px-5 py-3 text-sm  font-medium leading-5 text-white transition-colors duration-150 bg-teal-500 border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-teal-500 hover:bg-teal-500 focus:outline-none focus:shadow-outline-purple">
                        Update
                    </button>';
                    }
                    ?>
                </td>
            </form>
        </tr>
    <?php

    }
}

if (isset($_POST["addAgent"])) {
    // dd($_POST);
    $agentID = generateUniqueID();
    $agentName = $_POST["agentName"];
    $agentPhone = $_POST["agentPhone"];
    $agentEmail = $_POST["agentEmail"];
    $agentPasswd = $_POST["agentPass"];
    $agentConfirmPass = $_POST["agentConfirmPass"];
    $agentRegion = $_POST["agentRegion"];

    if ($agentPasswd !== $agentConfirmPass) {
        echo "<script>alert('Password do not match')</script>";
    } else {
        $Insert = "INSERT INTO `Agent`(`UniqueID`, `AgentName`, `AgentPhone`, `AgentEmail`, `Password`, `Region`) 
            VALUES ('$agentID','$agentName','$agentPhone','$agentEmail','$agentPasswd','$agentRegion')";

        // dd($Insert);
        $InsertConfirm = mysqli_query($conn, $Insert) or die(mysqli_error($conn));

        if ($InsertConfirm) {
            $message = "Hongera Agent! Account yako imetengenezwa. Bonyeza link hii kuingia https://express.smai.co.tz/ ingia kwa email yako $agentEmail.  Password yako ni $agentPasswd Download SMAI Express Agent app bonyeza https://t.ly/iDutd .";
            sendSMSAPI($agentPhone, $message);
            echo "Record entered successfully";
            header("Location:" . resolvePath('admin/app/views/agents.php'));
        } else {
            echo "Failed to set record. Contact Admin for support";
        }
    }
}

if (isset($_POST["edit_agent_form"])) {
    $editAgentName = $_POST["edit_name"];
    $editAgentPhone = $_POST["edit_email"];
    $editAgentEmail = $_POST["edit_phone"];
    $editAgentRegion = $_POST["edit_region"];
    $selected_agent = $_POST["selected_agent"];

    $submitType = $_POST["edit_agent_form"];
    if ($submitType === 'Delete') {
        $query = "DELETE FROM `Agent` WHERE AgentID = $selected_agent";
        if ($conn->query($query) === TRUE) {
            echo "Record deleted successfully";
            header("Location:" . resolvePath('admin/app/views/agents.php'));
        } else {
            echo "Error deleting record: " . $conn->error;
        }
    } elseif ($submitType === 'Update') {
        // Select initial values from the agents table
        $selectQuery = "SELECT AgentName, AgentPhone, AgentEmail, Region FROM `Agent` WHERE AgentID = $selected_agent";
        $result = $conn->query($selectQuery);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();

            // Compare the initial values with the new edited fields
            $updateFields = [];
            if ($editAgentName != $row["AgentName"]) {
                $updateFields[] = "AgentName = '$editAgentName'";
            }
            if ($editAgentPhone != $row["AgentPhone"]) {
                $updateFields[] = "AgentPhone = '$editAgentPhone'";
            }
            if ($editAgentEmail != $row["AgentEmail"]) {
                $updateFields[] = "AgentEmail = '$editAgentEmail'";
            }
            if ($editAgentRegion != $row["Region"]) {
                $updateFields[] = "Region = '$editAgentRegion'";
            }

            // If there are changes, run the update query
            if (!empty($updateFields)) {
                $updateQuery = "UPDATE `Agent` SET " . implode(", ", $updateFields) . " WHERE AgentID = $selected_agent";
                if ($conn->query($updateQuery) === TRUE) {
                    echo "Record updated successfully";
                    header("Location:" . resolvePath('admin/app/views/agents.php'));
                } else {
                    echo "Error updating record: " . $conn->error;
                }
            } else {
                echo "No changes to update.";
            }
        } else {
            echo "Agent not found.";
        }
    }
}

if (isset($_POST["update_payment"])) {
    $record_id = $_POST["record_id"];
    $Total_amount = $_POST["Total_amount"];
    $update_payed_amount = $_POST["update_payed_amount"];
    $update_payed_amount = $update_payed_amount ? $update_payed_amount : 0;
    $current_amount_payed = $_POST["current_amount_payed"];
    $new_payed_amount = $current_amount_payed + $update_payed_amount;

    if ($update_payed_amount <= 0) {
        // echo "No Number Entered";
        // die(0);
        header("Location:" . resolvePath('admin/app/views/agents.php'));
    }
    if ($Total_amount >= $new_payed_amount) {
        // echo "Proceed";
        // die(0);
        $updateQuery = "UPDATE `Payments` SET `Payed`='$new_payed_amount' WHERE `id` = $record_id";

        if ($conn->query($updateQuery) === TRUE) {
            echo "Payment information updated successfully";
            // Redirect
            header("Location:" . resolvePath('admin/app/views/agents.php'));
        } else {
            echo "Error updating payment information: " . $conn->error;
        }
    } else {
        echo "Warning: Invalid amount entered";
    }
    die(0);
}

/**
 * @returnAgentList: A fucntion that will simply return a table of agents with no fancy modifications
 * $agents: An array with agent information, grabbed from Agent Model
 * 
 */
function returnAgentList($agents)
{
    foreach ($agents as $agent) : ?>
        <tr class="text-gray-700 dark:text-gray-400">
            <td class="px-4 py-3">
                <a href="agentInspect.php?meta=<?= $agent["Id"] ?>">
                    <div class="flex items-center text-sm">
                        <!-- Avatar with inset shadow -->
                        <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                            <img class="object-cover w-full h-full rounded-full" src="<?= resolvePath('assets/img/user.png') ?>" alt="" loading="lazy" />
                            <div class="absolute inset-0 rounded-full shadow-inner" aria-hidden="true"></div>
                        </div>
                        <div>
                            <p class="font-semibold"><?= $agent["agentName"] ?></p>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                <?= $agent["agentEmail"] ?>
                            </p>
                        </div>
                    </div>
                </a>
            </td>

            <td class="px-4 py-3 text-sm">
                <a href="agentInspect.php?meta=<?= $agent["Id"] ?>">
                    <?= $agent["agentPhone"] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-xs">
                <a href="agentInspect.php?meta=<?= $agent["Id"] ?>">
                    <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-full dark:bg-green-700 dark:text-green-100">
                        <?= $agent["agentEmail"] ?>
                    </span>
                </a>
            </td>

            <td class="px-4 py-3 text-sm">
                <a href="agentInspect.php?meta=<?= $agent["Id"] ?>">
                    <?= $agent["agentRegion"] ?>
                </a>
            </td>
            <td>
                <a href="agentInspect.php?meta=<?= $agent["Id"] ?>">
                    <button type="button" title="view" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray">
                        <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                        </svg>
                    </button>
                </a>
            </td>
        </tr>
    <?php
    endforeach;
}

/**
 * returnAgetPackages: A funciton that will filter $packages array and return only packages
 * that belongs to the agent who's Id is passed.
 * retrun: agent's packages
 */
function returnAgetPackages($packages, $num)
{
    $agentPackages = array_filter($packages, function ($package) use ($num) {
        return isset($package['RecordingAgentID']) && $package['RecordingAgentID'] == $num;
    });

    return $agentPackages;
}

/**
 * agentReport: A function that returns the general report on agent performance
 * 
 * @param agents An array containing information about agents.
 * @param packages An array containing information about packages.
 * @return agentsReportData An array containing the agent report data.
 */
function agentReport($agents, $packages)
{
    $agentReportData = [];

    foreach ($agents as $agent) {
        $totalPackages = 0;
        $statusCounts = ['Received' => 0, 'In Transit' => 0, 'Delivered' => 0, 'Cleared' => 0];
        $totalCost = 0;

        foreach ($packages as $package) {
            if ($package['RecordingAgentID'] == $agent['Id']) {
                $totalPackages++;
                $status = $package['Status'];

                if (array_key_exists($status, $statusCounts)) {
                    $statusCounts[$status]++;
                    $totalCost += $package['ShippingFee'];
                }
            }
        }
        $agentReportData[] = [
            'agentId' => $agent['Id'],
            'agentName' => $agent['agentName'],
            'agentPhone' => $agent['agentPhone'],
            'totalPackages' => $totalPackages,
            'receivedCount' => $statusCounts['Received'],
            'inTransitCount' => $statusCounts['In Transit'],
            'deliveredCount' => $statusCounts['Delivered'],
            'clearedCount' => $statusCounts['Cleared'],
            'totalCost' => $totalCost,
        ];
    }
    return $agentReportData;
}

/**
 * sortAgentReport: A function that will take the returned array from agentReport function and sort it accodingly
 * 
 * @param array $agentReportData An array containing report of agents from the agentReport function
 * @param asortBy A variable from the $_GET request from user
 * @return sorted_html_table report for agents.
 */
function sortAgentReport($agentReportData, $sortBy)
{
    if (!isset($_GET['sort'])) {
        $sortBy = 'agentName';
    }

    if ($sortBy) {
        usort($agentReportData, function ($a, $b) use ($sortBy) {
            switch ($sortBy) {
                    // For numeric fields for descending order
                case 'totalPackages':
                case 'receivedCount':
                case 'inTransitCount':
                case 'deliveredCount':
                case 'clearedCount':
                case 'totalCost':
                    return $b[$sortBy] <=> $a[$sortBy];

                    // Other fields for lexicographical order
                default:
                    return $a[$sortBy] <=> $b[$sortBy];
            }
            return $a[$sortBy] <=> $b[$sortBy];
        });
    }
    foreach ($agentReportData as $agentData) : ?>

        <tr class="text-gray-700 dark:text-gray-400">
            <td class="px-4 py-3">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <div class="flex items-center text-sm">
                        <!-- Avatar with inset shadow -->
                        <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                            <img class="object-cover w-full h-full rounded-full" src="<?= resolvePath('assets/img/user.png') ?>" alt="" loading="lazy" />
                            <div class="absolute inset-0 rounded-full shadow-inner" aria-hidden="true"></div>
                        </div>
                        <div>
                            <p class="font-semibold"><?= $agentData["agentName"] ?></p>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                <?= $agentData["agentPhone"] ?>
                            </p>
                        </div>
                    </div>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= $agentData['totalPackages'] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= $agentData['receivedCount'] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= $agentData['inTransitCount'] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= $agentData['deliveredCount'] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= $agentData['clearedCount'] ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">
                    <?= formatPrice($agentData['totalCost']) . "/=" ?>
                </a>
            </td>
            <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                <a href="agentInspect.php?meta=<?= $agentData["agentId"] ?>">View</a>
            </td>
        </tr>

<?php endforeach;
}

/**
 * filterworkingArrByDate: @param workingArr from agentInspect.php. This function performs the cut-off operation on dates
 * @param cutoffDate: A variable that tells when should the data be cut out
 * @return workingArr 
 */
// function filterworkingArrByDate($workingArr, $cutoffDate)
// {
//     $filteredArr = [];
//     $count = 0;
//     $check = 0;
//     foreach ($workingArr as $package) {
//         $count++;
//         $packageDate = date('Y-m-d', strtotime($package['date']));
//          echo $package['date']. ' vs '.$cutoffDate.'<br>';
//         if ($packageDate >= $cutoffDate) {
//             echo ($packageDate. ' > '. $cutoffDate).'True'.'<br>';
//             $check++;
//             $filteredArr[] = $package;
//         }else{
//             echo ($packageDate. ' > '. $cutoffDate).'False'.'<br>';
//         }
//     }
//     echo 'Total = '.$count. ' Packages and '.$check.' shown';

//     return $filteredArr;
// }
function filterworkingArrByDate($workingArr, $cutoffDate)
{
    $filteredArr = [];
    // $count = 0;
    // $check = 0;
    foreach ($workingArr as $package) {
        // $count++;
        $packageDate = DateTime::createFromFormat('d/m/Y', $package['date'])->format('Y-m-d');
        // Check if $packageDate is false, which means the conversion failed
        // echo $package['date']. ' vs '.$cutoffDate.'<br>';
        if ($packageDate !== false && $packageDate >= $cutoffDate) {
            // echo ($packageDate. ' > '. $cutoffDate).'True'.'<br>';
            // $check++;
            $filteredArr[] = $package;
        } else {
            // echo ($packageDate. ' > '. $cutoffDate).'False'.'<br>';
        }
    }
    // echo 'Total = '.$count. ' Packages and '.$check.' shown';

    return $filteredArr;
}
