# smaiExpress - Logistics Automation System

smaiExpress is a comprehensive logistics automation system designed to streamline the process of shipping packages from one region to another. The system efficiently manages package recording, routing, notifications, and tracking, providing a seamless experience for both senders and receivers.

## Features

- **Package Recording:** Agents can record package details including sender and receiver information, package name, departure, and destination.

- **Automated Routing:** The system automatically assigns receiving agents based on package destinations, optimizing routing efficiency.

- **Notification Generation:** Real-time notifications are generated and sent to senders and receivers upon package recording and shipping.

- **Package Tracking:** Users can easily track the status of their packages using a unique tracking ID.

- **Reporting:** Management can access reports on package volumes, agent performance, and more.

## System Components

- **Database:** MySQL relational database is used to store package, agent, and notification data.

- **Backend:** Python-based backend handles business logic, database interactions, and notification generation.

- **Frontend:** A web interface provides package tracking, agent interactions, and user-friendly package submission.

## Getting Started

1. Clone the repository: `git clone https://github.com/your-username/smaiExpress.git`
2. Set up your MySQL database and update the database configuration in `config.py`.
3. Install required dependencies: `pip install -r requirements.txt`
4. Run the application backend: `python app.py`
5. Access the web interface in your browser: `http://localhost/smaiExpress`

## Usage

- Agents can log in and record package details, which are then routed and assigned to receiving agents automatically.
- Senders and receivers receive real-time notifications about their packages.
- Users can track package status using the provided tracking ID.

## Contributing

Contributions are welcome! If you find any bugs or have ideas for improvements, feel free to submit a pull request.

## License

This project is licensed under the [MIT License](LICENSE).

## Contact

For inquiries, please contact our team at support@smaiExpress.com.